Attribute VB_Name = "mdTranslateObjects"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

 
Rem Convenience function to translate the object set

Sub TranslateObjects(xDistance As Double, ydistance As Double, lineSet As ObjectSet)

'To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Rem Create the translation vector
Dim transvect1 As zVector
Set transvect1 = app.GetClass("Vector").CreateVector(xDistance, ydistance, 0)

Dim transvect As zVector
Set transvect = wp.Get3DVector(transvect1).subtract(wp.GetLocalOrigin)

Rem Create the Translation matrix
Dim transmat As zMatrix
Set transmat = app.GetClass("Matrix").CreateTranslationMatrix(transvect)

Rem Perform the transformation on the object set
wp.TransformObjects lineSet, transmat

End Sub


